#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Complex Atanh Circle Spiral 2Mod01.fsh  by   mla
//https://www.shadertoy.com/view/3sSSD1
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

////////////////////////////////////////////////////////////////////////////////
// Complex atanh generating a spiral of hexagonally touching 'circles'.
////////////////////////////////////////////////////////////////////////////////

float A = 3.0, B = 17.0; // Rotation angle is atan(B,A)
float scale = 2.0;
float PI = 3.14159;

// Complex functions
vec2 cmul(vec2 z, vec2 w) {
  return mat2(z,-z.y,z.x)*w;
}

vec2 cinv(vec2 z) {
  float t = dot(z,z);
  return vec2(z.x,-z.y)/t;
}

vec2 cdiv(vec2 z, vec2 w) {
  return cmul(z,cinv(w));
}

vec2 clog(vec2 z) {
  float r = length(z);
  return vec2(log(r),atan(z.y,z.x));
}

// Inverse hyperbolic tangent 
vec2 catanh(vec2 z) {
  return 0.5*clog(cdiv(vec2(1,0)+z,vec2(1,0)-z));
}

// Iq's hsv function, but just for hue.
vec3 h2rgb(float h ) {
  vec3 rgb = clamp( abs(mod(h*6.0+vec3(0.0,4.0,2.0),6.0)-3.0)-1.0, 0.0, 1.0 );
  return rgb*rgb*(3.0-2.0*rgb); // cubic smoothing	
}

// Shane's distance function showing the hexagonal cells.
float dist(vec2 p){
  float d0 = length(p);
  p = abs(p);
  float d1 = max(p.y*.8660254 + p.x*.5, p.x) + .025;
  return mix(d0,d1,0.5-0.5*cos(0.2*PI*iTime));
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
  float X = sqrt(3.0);
  vec2 z = (2.0*fragCoord-iResolution.xy)/iResolution.y;
  z *= scale;

  if (iMouse.x > 0.0) {
    // Get angle from mouse position
    vec2 m = (2.0*iMouse.xy-iResolution.xy)/iResolution.y;
    m *= 20.0;
    A = floor(m.x), B = floor(m.y);
  }
  vec2 rot = vec2(X*A,B);
  // Some alternative functions
  //z = clog(z);
  //z = 2.0*(3.0*catanh(z) - 2.0*catanh(cmul(vec2(cos(0.1*iTime),sin(0.1*iTime)), z)));
  //vec2 delta1 = (1.0-cos(0.15*iTime))*vec2(sin(0.25*iTime),cos(0.25*iTime));
  //vec2 delta2 = vec2(3.0*sin(0.3*iTime),1.5*sin(0.2*iTime));
  //vec2 delta3 = vec2(0);
  //z = clog(z+delta1) - clog(z+delta2) + clog(z+delta3);
  z = 2.0*catanh(z+vec2(0,1))+2.0*catanh(-z+vec2(0,1));
  z /= PI;
  float eps = length(rot)*fwidth(z.x);
  z = cmul(rot,z);
  z += iTime*vec2(1,0);
  // Divide into regions, 2 across, 2*sqrt(3) high
  z.y /= X;
  vec2 index = round(z);
  z -= index;
  z.y *= X;
  // z now relative to centre of region
  vec2 P = vec2(1,X); // upper right corner of region
  // Alternate regions are reversed left to right
  bool flip = mod(index.x + index.y, 2.0) == 0.0;
  if (flip) z.x = -z.x;
  bool lower = dot(z,P) < 0.0;
  // Adjust indexes
  if (flip == lower) index.x++;
  if (lower) index.y--;
  // Lower half of region has circle centred on lower left corner
  //float r = lower ? distance(-0.5*P,z) : distance(0.5*P,z);
  float r = lower ? dist(-0.5*P - z) : dist(0.5*P - z);
  float h = index.y/(2.0*(A==0.0 ? 1.0 : A)); // Color for row
  vec3 col = h2rgb(h);
  col = mix(col,vec3(0.01),r);
  col = mix(col,vec3(0.05),smoothstep(-eps,eps,r-1.0));
  // Uncomment next line to see fundamental regions
  //col *= 0.8+0.2*smoothstep(0.05-eps,0.05+eps,min(0.5-abs(z.x),0.5*X-abs(z.y)));
  col = pow(col,vec3(0.4545));
  fragColor = vec4(col,1);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

